/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util.autoupdates;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.ivw.common.util.autoupdates.AutoUpdatesInstallConstants;
import oracle.install.ivw.common.util.autoupdates.PostApplyUpdatesJob;
import oracle.install.ivw.common.util.autoupdates.PreApplyUpdatesJob;
import oracle.install.library.util.MachineInfo;
import oracle.ops.mgmt.cluster.ClusterCmd;

public class UpdatesHelper {
    private static UpdatesHelper instance = null;
    private String scratchPathLoc = System.getProperty("oracle.installer.scratchPath");
    private String sep = File.separator;
    private static final Logger logger = Logger.getLogger(UpdatesHelper.class.getName());

    public static UpdatesHelper getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (UpdatesHelper)(proxyFactory = ProxyFactory.getInstance()).createProxy(UpdatesHelper.class)) == null) {
            instance = new UpdatesHelper();
        }
        return instance;
    }

    public String getPrereqUpdateDir(String downloadLoc) {
        String[] bugNumbers;
        String prereqLoc = null;
        String updatesDir = "LatestUpdates";
        String shiphomeDir = "Shiphome";
        File parentFile = new File(this.scratchPathLoc + this.sep + updatesDir + this.sep + shiphomeDir);
        if (downloadLoc != null && downloadLoc.length() > 0) {
            logger.log(Level.INFO, "Updates download location: " + downloadLoc);
            parentFile = new File(downloadLoc + this.sep + updatesDir + this.sep + shiphomeDir);
        }
        if (parentFile != null && parentFile.exists() && (bugNumbers = parentFile.list()) != null) {
            for (String bug : bugNumbers) {
                String prereqDir = AutoUpdatesInstallConstants.PREREQ_UPDATES_DIR;
                File f = new File(parentFile + this.sep + bug + this.sep + prereqDir + this.sep + "cvu_prereq.xml");
                if (!f.exists()) continue;
                prereqLoc = f.getAbsolutePath();
                break;
            }
        }
        return prereqLoc;
    }

    public PreApplyUpdatesJob addPreApplyUpdatesJob(String downloadLoc, HashMap hashMap, String ... nodes) {
        PreApplyUpdatesJob preApplyUpdatesJob = null;
        logger.log(Level.FINEST, "INSIDE addPreApplyUpdatesJob API");
        File customJobPropertiesFile = this.getCustomJobPropertiesFile(downloadLoc);
        if (customJobPropertiesFile != null && customJobPropertiesFile.length() > 0L && customJobPropertiesFile.exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(customJobPropertiesFile));
                if (properties.getProperty("PRE_SCRIPT_LOC") != null && properties.getProperty("PRE_SCRIPT_LOC").length() > 0) {
                    if (nodes != null && nodes.length > 0) {
                        preApplyUpdatesJob = new PreApplyUpdatesJob(downloadLoc, hashMap, nodes);
                    } else {
                        logger.log(Level.FINEST, "INSIDE addPreApplyUpdatesJob API NO NODES FOUND");
                        preApplyUpdatesJob = new PreApplyUpdatesJob(downloadLoc, hashMap, new String[0]);
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error while reading the custom job properties file. Disabling pre apply updates job.");
                return null;
            }
        }
        return preApplyUpdatesJob;
    }

    public PostApplyUpdatesJob addPostApplyUpdatesJob(String downloadLoc, HashMap hashMap, String ... nodes) {
        PostApplyUpdatesJob postApplyUpdatesJob = null;
        File customJobPropertiesFile = this.getCustomJobPropertiesFile(downloadLoc);
        if (customJobPropertiesFile != null && customJobPropertiesFile.length() > 0L && customJobPropertiesFile.exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(customJobPropertiesFile));
                if (properties.getProperty("POST_SCRIPT_LOC") != null && properties.getProperty("POST_SCRIPT_LOC").length() > 0) {
                    postApplyUpdatesJob = nodes != null && nodes.length > 0 ? new PostApplyUpdatesJob(downloadLoc, hashMap, nodes) : new PostApplyUpdatesJob(downloadLoc, hashMap, new String[0]);
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error while reading the custom job properties file. Disabling post apply updates job.");
                return null;
            }
        }
        return postApplyUpdatesJob;
    }

    public File getCustomJobPropertiesFile(String downloadLoc) {
        String[] bugNumbers;
        File propFile = null;
        logger.log(Level.FINEST, "INSIDE getCustomJobPropertiesFile API");
        String updatesDirName = "LatestUpdates";
        String shiphomeDirName = "Shiphome";
        File shiphomeDir = new File(downloadLoc + File.separator + updatesDirName, shiphomeDirName);
        if (shiphomeDir != null && shiphomeDir.exists() && (bugNumbers = shiphomeDir.list()) != null) {
            for (String bug : bugNumbers) {
                String customJobPropFile = AutoUpdatesInstallConstants.CUSTOM_JOB_PROPERTIES_DIR;
                File f = new File(shiphomeDir + this.sep + bug + this.sep + customJobPropFile);
                if (!f.exists()) continue;
                logger.log(Level.FINEST, "INSIDE getCustomJobPropertiesFile API, found: " + f.getAbsolutePath());
                propFile = f;
            }
        }
        if (propFile != null) {
            logger.log(Level.FINEST, "From getCustomJobPropertiesFile API: returning: " + propFile.getAbsolutePath());
        }
        return propFile;
    }

    public boolean executeScript(String scriptToRun, String[] args, String[] nodes) {
        if (nodes == null || nodes.length == 0) {
            String localNode = MachineInfo.getInstance().getFullHostName();
            nodes = new String[]{localNode};
        }
        boolean cmdStatus = false;
        String scriptName = new File(scriptToRun).getName();
        if (nodes != null && nodes.length > 0) {
            ClusterCmd clusterCmd = new ClusterCmd();
            String tmpPath = System.getProperty("java.io.tmpdir");
            for (String n : nodes) {
                try {
                    boolean copiedScript = false;
                    if (!clusterCmd.fileExists(n, tmpPath)) {
                        logger.info("Copying " + scriptToRun + " to node " + n);
                        clusterCmd.copyFileToNode(scriptToRun, n, tmpPath + File.separator + scriptName);
                        logger.info("Copied " + scriptToRun + " to node " + n);
                        copiedScript = true;
                    }
                    if (!copiedScript) continue;
                    boolean val = clusterCmd.runCmd(tmpPath + File.separator + scriptName, args, null, nodes);
                    if (val) {
                        logger.info("Successfully executed script " + tmpPath + File.separator + scriptName + " on all nodes");
                        cmdStatus = true;
                        continue;
                    }
                    logger.log(Level.WARNING, "Error when executing script " + tmpPath + File.separator + scriptName);
                    cmdStatus = false;
                }
                catch (Exception e) {
                    cmdStatus = false;
                    logger.log(Level.WARNING, "ClusterException while copying the script " + scriptName, e);
                }
            }
        }
        return cmdStatus;
    }
}

